<?php
/*
 *  T4B News Ticker v1.2.7 - 11 Febryary, 2023
 *  By @realwebcare - https://www.realwebcare.com/
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/* Sidebar */
add_action( 't4bnt_settings_content', 't4bnt_sidebar' );
if( !function_exists( 't4bnt_sidebar' ) ){
	function t4bnt_sidebar() { ?>
		<div id="t4bnt-sidebar" class="postbox-container">
			<div id="t4bntusage-shortcode" class="t4bntusage-sidebar">
				<h3><?php _e('Plugin Shortcode', 't4bnt'); ?></h3>
				<p><?php _e('To display a news ticker shortcode in a WordPress post or page, you need to access the post or page editor in the WordPress dashboard. Here\'s how:', 't4bnt'); ?></p>
				<ol>
					<li><?php _e('Go to Posts or Pages, depending on where you want to display the news ticker.', 't4bnt'); ?></li>
					<li><?php _e('Either create a new post or page, or edit an existing one.', 't4bnt'); ?></li>
					<li><?php _e('Switch to the visual editor if it\'s not already active.', 't4bnt'); ?></li>
					<li><?php _e('Locate the spot in the post or page where you want to display the news ticker.', 't4bnt'); ?></li>
					<li class="t4b-scode">
						<?php _e('Paste the following shortcode into the editor:', 't4bnt'); ?>
						<input id="t4bntShortcode" type="text" class="t4bnt-shortcode" name="t4bnt_shortcode" value="<?php echo esc_html('[t4b-ticker]'); ?>" onclick="t4bntFunction()" onmouseout="t4bntoutFunc()">
						<span class="copy-tooltip" id="t4bntTooltip">Click to Copy Shortcode!</span>
					</li>
					<li><?php _e('Save or publish the post or page.', 't4bnt'); ?></li>
				</ol>
				<p><?php _e('Once you\'ve saved or published the post or page, the news ticker shortcode will be processed and the news ticker will be displayed on the front end of your site.', 't4bnt'); ?></p>
			</div>
			<div id="t4bntusage-premium" class="t4bntusage-sidebar">
            	<h3><?php _e('Code Usage Instruction in a Theme', 't4bnt'); ?></h3>
                <div class="t4bnt">
					<p><?php _e('To display a news ticker shortcode in a WordPress theme file, you can use the ', 't4bnt'); ?><strong><?php _e('do_shortcode', 't4bnt'); ?></strong> <?php _e(' function:', 't4bnt'); ?></p>
					<pre><code><span class="t4bnt-meta">&lt;?php</span> <span class="t4bnt-keyword">echo</span> <span class="t4bnt-function">do_shortcode</span>(<span class="t4bnt-string">'[t4b-ticker]'</span>); <span class="t4bnt-meta">?&gt;</span></code></pre>
					<p><?php _e('You can place this code anywhere in your theme file where you want the news ticker to appear. For example, you could place it in the template file for a specific page of your site.', 't4bnt'); ?></p>
                	<p><?php _e('Keep in mind that if you are making changes directly to your theme files, those changes will be overwritten if you update the theme. To avoid this, you can create a child theme and make your changes there instead.', 't4bnt'); ?></p>
                </div>
			</div>
			<div id="t4bntusage-info" class="t4bntusage-sidebar">
				<h3><?php _e('Plugin Info', 't4bnt'); ?></h3>
				<ul class="t4bntusage-list">
					<li><?php _e('Version: 1.2.7', 't4bnt'); ?></li>
					<li><?php _e('Scripts: PHP + CSS + JS', 't4bnt'); ?></li>
					<li><?php _e('Requires: Wordpress 5.4+', 't4bnt'); ?></li>
					<li><?php _e('First release: 29 December, 2014', 't4bnt'); ?></li>
					<li><?php _e('Last Update: 11 February, 2023', 't4bnt'); ?></li>
					<li><?php _e('By', 't4bnt'); ?>: <a href="https://www.realwebcare.com/" target="_blank"><?php _e('Realwebcare', 't4bnt'); ?></a><br/>
					<li><?php _e('Need Help', 't4bnt'); ?>? <a href="https://wordpress.org/support/plugin/t4b-news-ticker/" target="_blank">Support</a><br/>
                    <li><?php _e('Like it? Please leave us a', 't4bnt'); ?> <a target="_blank" href="https://wordpress.org/support/plugin/t4b-news-ticker/reviews/?filter=5/#new-post">&#9733;&#9733;&#9733;&#9733;&#9733;</a> <?php _e('rating. We highly appreciate your support!', 't4bnt'); ?><br/>
					<li><?php _e('Published under', 't4bnt'); ?>: <a href="http://www.gnu.org/licenses/gpl.txt"><?php _e('GNU General Public License', 't4bnt'); ?></a>
				</ul>
			</div>
		</div><?php
	}
}
require_once ( T4BNT_PLUGIN_PATH . 'ticker-shortcode.php' );
require_once ( T4BNT_PLUGIN_PATH . 'class/t4bnt-class.settings-api.php' );
require_once ( T4BNT_PLUGIN_PATH . 'inc/ticker-settings.php' );
?>